﻿using System;
using System.Collections.Generic;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Input;
using System.Windows.Media;
using System.Windows.Media.Imaging;

namespace TouchEvents
{
    public partial class MainWindow : Window
    {
        // Powiazanie obrazów z obiektami TouchDevice
        Dictionary<TouchDevice, Image> fingerprints = new Dictionary<TouchDevice, Image>();
 
        public MainWindow()
        {
            InitializeComponent();
        }

        protected override void OnTouchDown(TouchEventArgs e)
        {
            base.OnTouchDown(e);

            // Przechwycenie urządzenia dotykowego
            canvas.CaptureTouch(e.TouchDevice);

            // Tworzenie nowego obrazu dla tego dotknięcia
            Image fingerprint = new Image { Source = new BitmapImage(new Uri("pack://application:,,,/fingerprint.png")) };

            // Przesunięcie obrazu do punktu dotknięcia
            TouchPoint point = e.GetTouchPoint(canvas);
            fingerprint.RenderTransform = new TranslateTransform(point.Position.X, point.Position.Y);

            // Zapisanie obrazu i umieszczenie na płótnie
            fingerprints[e.TouchDevice] = fingerprint;
            canvas.Children.Add(fingerprint);
        }

        protected override void OnTouchMove(TouchEventArgs e)
        {
            base.OnTouchMove(e);

            if (e.TouchDevice.Captured == canvas)
            {
                // Pobranie właściwego obrazu
                Image fingerprint = fingerprints[e.TouchDevice];
                TranslateTransform transform = fingerprint.RenderTransform as TranslateTransform;

                // Przesunięcie do nowej lokalizacji
                TouchPoint point = e.GetTouchPoint(canvas);
                transform.X = point.Position.X;
                transform.Y = point.Position.Y;
            }
        }

        protected override void OnTouchUp(TouchEventArgs e)
        {
            base.OnTouchUp(e);

            // Zwolnienie urządzenia
            canvas.ReleaseTouchCapture(e.TouchDevice);

            // Usunięcie obrazu z płótna i słownika
            canvas.Children.Remove(fingerprints[e.TouchDevice]);
            fingerprints.Remove(e.TouchDevice);
        }
    }
}